/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.recipe;

import io.github.foundationgames.automobility.Automobility;
import io.github.foundationgames.automobility.recipe.AutoMechanicTableRecipeSerializer;
import io.github.foundationgames.automobility.recipe.ContainerRecipeInput;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoMechanicTableRecipe
implements Recipe<ContainerRecipeInput>,
Comparable<AutoMechanicTableRecipe> {
    public static final ResourceLocation ID = Automobility.rl("auto_mechanic_table");
    public static final RecipeType<AutoMechanicTableRecipe> TYPE = new RecipeType<AutoMechanicTableRecipe>(){};
    protected final ResourceLocation category;
    protected final List<Ingredient> ingredients;
    protected final ItemStack result;
    protected final int sortNum;
    @Nullable
    public ResourceLocation sortId;

    public AutoMechanicTableRecipe(ResourceLocation category, List<Ingredient> ingredients, ItemStack result, int sortNum) {
        this.category = category;
        this.ingredients = ingredients;
        this.result = result;
        this.sortNum = sortNum;
    }

    public ResourceLocation getCategory() {
        return this.category;
    }

    public boolean matches(ContainerRecipeInput inv, Level lvl) {
        boolean[] result = new boolean[]{true};
        this.forMissingIngredients(inv, ing -> {
            result[0] = false;
        });
        return result[0];
    }

    public ItemStack assemble(ContainerRecipeInput inv, HolderLookup.Provider var2) {
        return this.assemble(inv);
    }

    public ItemStack assemble(ContainerRecipeInput inv) {
        block0: for (Ingredient ing : this.ingredients) {
            for (int i = 0; i < inv.size(); ++i) {
                ItemStack stack = inv.getItem(i);
                if (!ing.test(stack)) continue;
                stack.shrink(1);
                continue block0;
            }
        }
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider var1) {
        return this.getResultItem();
    }

    public ItemStack getResultItem() {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return AutoMechanicTableRecipeSerializer.INSTANCE;
    }

    public RecipeType<?> getType() {
        return TYPE;
    }

    public void forMissingIngredients(ContainerRecipeInput inv, Consumer<Ingredient> action) {
        ArrayList<ItemStack> invCopy = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.size(); ++i) {
            invCopy.add(inv.getItem(i));
        }
        for (Ingredient ing : this.ingredients) {
            if (invCopy.stream().noneMatch(ing)) {
                action.accept(ing);
                continue;
            }
            invCopy.remove(invCopy.stream().filter(ing).collect(Collectors.toList()).get(0));
        }
    }

    @Override
    public int compareTo(@NotNull AutoMechanicTableRecipe o) {
        int diff = this.getCategory().compareTo(o.getCategory());
        if (diff != 0) {
            return diff;
        }
        diff = Integer.compare(this.sortNum, o.sortNum);
        if (diff != 0) {
            return diff;
        }
        if (this.sortId != null && o.sortId != null) {
            return this.sortId.compareTo(o.sortId);
        }
        return this.getResultItem().getItemHolder().getRegisteredName().compareTo(o.getResultItem().getItemHolder().getRegisteredName());
    }
}

